/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.core.Device;
import java.util.concurrent.locks.LockSupport;

public abstract class TimedDevice
extends Device {
    private static final double NANOS_PER_SECOND = 1.0E9;
    private int cycleTimer = 0;
    private Thread worker;
    Thread timerThread;
    long nanosPerInterval;
    long cyclesPerInterval;
    long nextSync;
    long skip = 0L;
    long wait = 0L;

    public abstract void tick();

    public void kill() {
        this.setRun(false);
        if (this.worker != null && this.worker.isAlive()) {
            try {
                this.worker.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.worker = null;
    }

    public void go() {
        this.kill();
        this.setSpeed(this.cyclesPerSecond());
        this.setRun(true);
        this.worker = new Thread(new Runnable(){

            public void run() {
                while (TimedDevice.this.isRunning()) {
                    TimedDevice.this.doTick();
                    TimedDevice.this.resync();
                }
            }
        });
        this.worker.setDaemon(false);
        this.worker.setPriority(6);
        this.worker.start();
        this.worker.setName(this.getDeviceName());
    }

    public void setSpeed(long cyclesPerSecond) {
        this.cyclesPerInterval = cyclesPerSecond / 100L;
        double desired = 1.0E9 / (double)cyclesPerSecond;
        this.nanosPerInterval = (long)((double)this.cyclesPerInterval * desired);
        this.nextSync = System.nanoTime() + this.nanosPerInterval;
    }

    protected void resync() {
        if ((long)(++this.cycleTimer) >= this.cyclesPerInterval) {
            this.cycleTimer = 0;
            long currentSyncDiff = this.nextSync - System.nanoTime();
            this.nextSync += this.nanosPerInterval;
            if (currentSyncDiff > 0L) {
                if (currentSyncDiff > 2000000L) {
                    try {
                        Thread.sleep(currentSyncDiff / 1000000L, (int)(currentSyncDiff % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    LockSupport.parkNanos(currentSyncDiff);
                }
            }
        }
    }

    public abstract long cyclesPerSecond();
}

